/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory.item;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.validator.ItemValidatorBasic;
import com.raoulvdberge.refinedstorage.item.ItemUpgrade;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class ItemHandlerUpgrade
extends ItemHandlerBase {
    private final Int2IntMap upgradeCountMap = new Int2IntOpenHashMap();
    private int energyUsage;
    private int fortuneLevel;

    public ItemHandlerUpgrade(int size, @Nullable Consumer<Integer> listener, int ... supportedUpgrades) {
        super(size, listener, new ItemValidatorBasic[supportedUpgrades.length]);
        for (int i = 0; i < supportedUpgrades.length; ++i) {
            this.validators[i] = new ItemValidatorBasic(RSItems.UPGRADE, supportedUpgrades[i]);
        }
    }

    @Override
    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.energyUsage = 0;
        this.fortuneLevel = 0;
        this.upgradeCountMap.clear();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            this.energyUsage += ItemUpgrade.getEnergyUsage(stack);
            this.fortuneLevel = Math.max(this.fortuneLevel, ItemUpgrade.getFortuneLevel(stack));
            this.upgradeCountMap.merge((Object)stack.func_77952_i(), (Object)1, Integer::sum);
        }
    }

    public int getSpeed() {
        return this.getSpeed(9, 2);
    }

    public int getSpeed(int speed, int speedIncrease) {
        return speed - speedIncrease * this.upgradeCountMap.get(2);
    }

    public boolean hasUpgrade(int type) {
        return this.getUpgradeCount(type) > 0;
    }

    public int getUpgradeCount(int type) {
        return this.upgradeCountMap.get(type);
    }

    public int getEnergyUsage() {
        return this.energyUsage;
    }

    public int getFortuneLevel() {
        return this.fortuneLevel;
    }

    public int getItemInteractCount() {
        return this.hasUpgrade(4) ? 64 : 1;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }
}

